<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #333;
        }

        .admin-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
            padding: 1rem 0;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
        }

        .nav-container {
            max-width: 1400px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 2rem;
        }

        .nav-brand {
            font-size: 1.5rem;
            font-weight: 700;
            color: #4a5568;
            text-decoration: none;
        }

        .nav-links {
            display: flex;
            gap: 0;
        }

        .nav-links a {
            color: #4a5568;
            text-decoration: none;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .nav-links a:hover {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }

        .nav-links a.active {
            background: #667eea;
            color: white;
            box-shadow: 0 2px 10px rgba(102, 126, 234, 0.3);
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .user-info {
            font-size: 0.9rem;
            color: #666;
        }

        .logout-btn {
            background: #e53e3e;
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .logout-btn:hover {
            background: #c53030;
            transform: translateY(-1px);
        }

        .main-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 2rem;
        }

        .page-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .page-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }

        .page-subtitle {
            color: #718096;
            font-size: 1.1rem;
        }

        .tools-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 2rem;
            margin-bottom: 2rem;
        }

        .tool-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            transition: all 0.3s ease;
            position: relative;
        }

        .tool-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 40px rgba(0, 0, 0, 0.15);
        }

        .tool-card.primary {
            border-top: 4px solid #667eea;
        }

        .tool-card.success {
            border-top: 4px solid #38a169;
        }

        .tool-card.warning {
            border-top: 4px solid #ed8936;
        }

        .tool-icon {
            font-size: 3rem;
            color: #667eea;
            margin-bottom: 1rem;
        }

        .tool-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 1rem;
        }

        .tool-description {
            color: #718096;
            margin-bottom: 1.5rem;
            line-height: 1.6;
        }

        .tool-stats {
            background: #f7fafc;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1.5rem;
            font-size: 0.9rem;
        }

        .stat-row {
            display: flex;
            justify-content: space-between;
            padding: 0.5rem 0;
            border-bottom: 1px solid #e2e8f0;
        }

        .stat-row:last-child {
            border-bottom: none;
        }

        .stat-label {
            color: #718096;
        }

        .stat-value {
            font-weight: 600;
            color: #2d3748;
        }

        .btn {
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            cursor: pointer;
            font-size: 0.95rem;
        }

        .btn:hover {
            transform: translateY(-1px);
            text-decoration: none;
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }

        .btn-primary:hover {
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
            color: white;
        }

        .btn-secondary {
            background: #f7fafc;
            color: #4a5568;
            border: 2px solid #e2e8f0;
        }

        .btn-secondary:hover {
            background: #edf2f7;
            color: #4a5568;
        }

        .btn-success {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(40, 167, 69, 0.3);
        }

        .btn-success:hover {
            box-shadow: 0 6px 20px rgba(40, 167, 69, 0.4);
            color: white;
        }

        .btn-warning {
            background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(251, 191, 36, 0.3);
        }

        .btn-warning:hover {
            box-shadow: 0 6px 20px rgba(251, 191, 36, 0.4);
            color: white;
        }

        .alert {
            padding: 1rem 1.5rem;
            border-radius: 10px;
            margin-bottom: 2rem;
            border-left: 4px solid;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .alert-info {
            background: #ebf8ff;
            border-color: #4299e1;
            color: #2b6cb0;
        }

        .badge {
            padding: 0.25rem 0.75rem;
            border-radius: 12px;
            font-size: 0.7rem;
            font-weight: 600;
            text-transform: uppercase;
            margin-left: 0.5rem;
        }

        .badge-new {
            background: #667eea;
            color: white;
        }

        .badge-beta {
            background: #ed8936;
            color: white;
        }

        @media (max-width: 768px) {
            .main-container {
                padding: 1rem;
            }
            
            .tools-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <header class="admin-header">
        <div class="nav-container">
            <a href="/admin/dashboard" class="nav-brand">
                <i class="fas fa-store"></i> Business Directory Admin
            </a>
            
            <nav class="nav-links">
                <a href="/admin/dashboard">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
                <a href="/admin/stores">
                    <i class="fas fa-building"></i> Stores
                </a>
                <a href="/admin/hours">
                    <i class="fas fa-clock"></i> Hours
                </a>
                <a href="/admin/categories">
                    <i class="fas fa-tags"></i> Categories
                </a>
                <a href="/admin/tools" class="active">
                    <i class="fas fa-tools"></i> Tools
                </a>
            </nav>
            
            <div class="user-menu">
                <div class="user-info">
                    <i class="fas fa-user-circle"></i>
                    <?= session()->get('admin_name') ?: 'Admin' ?>
                </div>
                <a href="/admin/logout" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
        </div>
    </header>

    <main class="main-container">
        <div class="page-header">
            <h1 class="page-title">
                <i class="fas fa-tools"></i> <?= $heading ?>
            </h1>
            <p class="page-subtitle">
                Administrative tools for managing business users and system maintenance
            </p>
        </div>

        <div class="tools-grid">
            <!-- Business User Management Tool -->
            <div class="tool-card primary">
                <div class="tool-icon">
                    <i class="fas fa-users-cog"></i>
                </div>
                <h2 class="tool-title">
                    Business User Management
                    <?php if ($businessUserCount < $totalStores): ?>
                        <span class="badge badge-new">Action Needed</span>
                    <?php endif; ?>
                </h2>
                <p class="tool-description">
                    Generate login credentials for businesses and manage their access to the self-service portal.
                </p>
                
                <div class="tool-stats">
                    <div class="stat-row">
                        <span class="stat-label">Total Businesses:</span>
                        <span class="stat-value"><?= number_format($totalStores) ?></span>
                    </div>
                    <div class="stat-row">
                        <span class="stat-label">Users Created:</span>
                        <span class="stat-value"><?= number_format($businessUserCount) ?></span>
                    </div>
                    <div class="stat-row">
                        <span class="stat-label">Remaining:</span>
                        <span class="stat-value" style="color: <?= ($totalStores - $businessUserCount) > 0 ? '#e53e3e' : '#38a169' ?>">
                            <?= number_format($totalStores - $businessUserCount) ?>
                        </span>
                    </div>
                </div>
                
                <div style="display: flex; gap: 1rem;">
                    <?php if ($businessUserCount < $totalStores): ?>
                        <a href="/admin/tools/generate-users" class="btn btn-primary">
                            <i class="fas fa-user-plus"></i> Generate Users
                        </a>
                    <?php endif; ?>
                    <a href="/admin/tools/manage-passwords" class="btn btn-secondary">
                        <i class="fas fa-key"></i> Manage Passwords
                    </a>
                </div>
            </div>

            <!-- Change Request Management -->
            <div class="tool-card success">
                <div class="tool-icon">
                    <i class="fas fa-clipboard-check"></i>
                </div>
                <h2 class="tool-title">
                    Change Request Management
                </h2>
                <p class="tool-description">
                    Review and approve business profile updates submitted through the self-service portal.
                </p>
                
                <div class="tool-stats">
                    <div class="stat-row">
                        <span class="stat-label">Pending Requests:</span>
                        <span class="stat-value"><?= $pendingRequests ?? 0 ?></span>
                    </div>
                </div>
                
                <a href="/admin/change-requests" class="btn btn-success">
                    <i class="fas fa-clipboard-list"></i> Review Requests
                </a>
            </div>

            <!-- Email Test Tool -->
            <div class="tool-card warning">
                <div class="tool-icon">
                    <i class="fas fa-envelope"></i>
                </div>
                <h2 class="tool-title">
                    Email System Test
                    <span class="badge badge-beta">Beta</span>
                </h2>
                <p class="tool-description">
                    Test the email notification system to ensure proper delivery of business communications.
                </p>
                
                <a href="/admin/change-requests/test-email" class="btn btn-warning">
                    <i class="fas fa-paper-plane"></i> Test Email
                </a>
            </div>
        </div>

        <?php if ($businessUserCount == 0 && $totalStores > 0): ?>
        <div class="alert alert-info">
            <i class="fas fa-info-circle"></i>
            <strong>Get Started:</strong> No business users have been created yet. Use the "Generate Users" tool to create login credentials for all <?= number_format($totalStores) ?> businesses in your directory.
        </div>
        <?php endif; ?>
    </main>
</body>
</html>