<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #333;
        }

        .admin-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
            padding: 1rem 0;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
        }

        .nav-container {
            max-width: 1400px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 2rem;
        }

        .nav-brand {
            font-size: 1.5rem;
            font-weight: 700;
            color: #4a5568;
            text-decoration: none;
        }

        .nav-links {
            display: flex;
            gap: 0;
        }

        .nav-links a {
            color: #4a5568;
            text-decoration: none;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .nav-links a:hover {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }

        .nav-links a.active {
            background: #667eea;
            color: white;
            box-shadow: 0 2px 10px rgba(102, 126, 234, 0.3);
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .user-info {
            font-size: 0.9rem;
            color: #666;
        }

        .logout-btn {
            background: #e53e3e;
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .logout-btn:hover {
            background: #c53030;
            transform: translateY(-1px);
        }

        .main-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 2rem;
        }

        .page-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .page-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }

        .page-subtitle {
            color: #718096;
            font-size: 1.1rem;
        }

        .summary-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin-bottom: 2rem;
        }

        .stat-box {
            background: #f7fafc;
            border-radius: 8px;
            padding: 1.5rem;
            text-align: center;
            border: 2px solid #e2e8f0;
        }

        .stat-box.success {
            border-color: #38a169;
            background: #f0fdf4;
        }

        .stat-box.error {
            border-color: #e53e3e;
            background: #fef2f2;
        }

        .stat-value {
            font-size: 2.5rem;
            font-weight: 700;
        }

        .stat-value.success {
            color: #38a169;
        }

        .stat-value.error {
            color: #e53e3e;
        }

        .stat-label {
            font-size: 0.9rem;
            color: #718096;
            margin-top: 0.5rem;
        }

        .results-table {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 1.5rem;
            margin-bottom: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            overflow-x: auto;
        }

        .table-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th {
            background: #f7fafc;
            padding: 0.75rem 1rem;
            text-align: left;
            font-weight: 600;
            color: #4a5568;
            border-bottom: 2px solid #e2e8f0;
            position: sticky;
            top: 0;
        }

        td {
            padding: 0.75rem 1rem;
            border-bottom: 1px solid #e2e8f0;
        }

        tr:hover {
            background: #f7fafc;
        }

        .business-name {
            font-weight: 600;
            color: #2d3748;
        }

        .credentials {
            font-family: 'Courier New', monospace;
            background: #edf2f7;
            padding: 0.25rem 0.5rem;
            border-radius: 4px;
            font-size: 0.9rem;
        }

        .error-message {
            color: #e53e3e;
            font-size: 0.9rem;
        }

        .btn {
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            cursor: pointer;
            font-size: 0.95rem;
        }

        .btn:hover {
            transform: translateY(-1px);
            text-decoration: none;
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }

        .btn-primary:hover {
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
            color: white;
        }

        .btn-success {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(40, 167, 69, 0.3);
        }

        .btn-success:hover {
            box-shadow: 0 6px 20px rgba(40, 167, 69, 0.4);
            color: white;
        }

        .btn-secondary {
            background: #f7fafc;
            color: #4a5568;
            border: 2px solid #e2e8f0;
        }

        .btn-secondary:hover {
            background: #edf2f7;
            color: #4a5568;
        }

        .action-buttons {
            display: flex;
            gap: 1rem;
            margin-top: 2rem;
            justify-content: center;
        }

        .alert {
            padding: 1rem 1.5rem;
            border-radius: 10px;
            margin-bottom: 2rem;
            border-left: 4px solid;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .alert-success {
            background: #f0fdf4;
            border-color: #38a169;
            color: #276749;
        }

        .alert-warning {
            background: #fffaf0;
            border-color: #ed8936;
            color: #975a16;
        }

        .download-section {
            background: linear-gradient(135deg, #38a169 0%, #20c997 100%);
            border-radius: 16px;
            padding: 2rem;
            text-align: center;
            color: white;
            margin-bottom: 2rem;
        }

        .download-icon {
            font-size: 3rem;
            margin-bottom: 1rem;
        }

        .download-title {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }

        .download-text {
            margin-bottom: 1.5rem;
            opacity: 0.9;
        }

        @media (max-width: 768px) {
            .main-container {
                padding: 1rem;
            }
            
            .stats-grid {
                grid-template-columns: 1fr;
            }
            
            .action-buttons {
                flex-direction: column;
            }
            
            .btn {
                width: 100%;
                justify-content: center;
            }
            
            .results-table {
                padding: 1rem;
            }
            
            td, th {
                padding: 0.5rem;
                font-size: 0.85rem;
            }
        }
    </style>
</head>
<body>
    <header class="admin-header">
        <div class="nav-container">
            <a href="/admin/dashboard" class="nav-brand">
                <i class="fas fa-store"></i> Business Directory Admin
            </a>
            
            <nav class="nav-links">
                <a href="/admin/dashboard">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
                <a href="/admin/stores">
                    <i class="fas fa-building"></i> Stores
                </a>
                <a href="/admin/hours">
                    <i class="fas fa-clock"></i> Hours
                </a>
                <a href="/admin/categories">
                    <i class="fas fa-tags"></i> Categories
                </a>
                <a href="/admin/tools" class="active">
                    <i class="fas fa-tools"></i> Tools
                </a>
            </nav>
            
            <div class="user-menu">
                <div class="user-info">
                    <i class="fas fa-user-circle"></i>
                    <?= session()->get('admin_name') ?: 'Admin' ?>
                </div>
                <a href="/admin/logout" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
        </div>
    </header>

    <main class="main-container">
        <div class="page-header">
            <h1 class="page-title">
                <i class="fas fa-check-circle"></i> <?= $heading ?>
            </h1>
            <p class="page-subtitle">
                Business user accounts have been generated successfully
            </p>
        </div>

        <?php if ($created > 0): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i>
            <strong>Success!</strong> Generated <?= $created ?> business user accounts. Download the credentials below for distribution.
        </div>
        <?php endif; ?>

        <?php if ($errors > 0): ?>
        <div class="alert alert-warning">
            <i class="fas fa-exclamation-triangle"></i>
            <strong>Warning:</strong> <?= $errors ?> accounts failed to create. See details below.
        </div>
        <?php endif; ?>

        <div class="summary-card">
            <div class="stats-grid">
                <div class="stat-box">
                    <div class="stat-value"><?= $total ?></div>
                    <div class="stat-label">Total Processed</div>
                </div>
                <div class="stat-box success">
                    <div class="stat-value success"><?= $created ?></div>
                    <div class="stat-label">Successfully Created</div>
                </div>
                <?php if ($errors > 0): ?>
                <div class="stat-box error">
                    <div class="stat-value error"><?= $errors ?></div>
                    <div class="stat-label">Failed</div>
                </div>
                <?php endif; ?>
            </div>

            <?php if ($created > 0): ?>
            <div class="download-section">
                <div class="download-icon">
                    <i class="fas fa-file-csv"></i>
                </div>
                <h2 class="download-title">Download Credentials</h2>
                <p class="download-text">
                    Click below to download a CSV file containing all usernames and passwords.<br>
                    <strong>Important:</strong> Save this file securely - it contains sensitive login information.
                </p>
                <a href="/admin/tools/download-credentials" class="btn btn-success" style="background: white; color: #38a169;">
                    <i class="fas fa-download"></i> Download CSV File
                </a>
            </div>
            <?php endif; ?>
        </div>

        <?php if (!empty($results) && count($results) <= 20): ?>
        <div class="results-table">
            <h3 class="table-title">
                <i class="fas fa-list"></i> Generation Details
            </h3>
            <table>
                <thead>
                    <tr>
                        <th>Business Name</th>
                        <th>Username</th>
                        <th>Password</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($results as $result): ?>
                    <tr>
                        <td class="business-name"><?= esc($result['store_name']) ?></td>
                        <td>
                            <?php if ($result['success']): ?>
                                <span class="credentials"><?= esc($result['username']) ?></span>
                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($result['success']): ?>
                                <span class="credentials"><?= esc($result['password']) ?></span>
                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($result['success']): ?>
                                <i class="fas fa-check-circle" style="color: #38a169;"></i> Created
                            <?php else: ?>
                                <span class="error-message">
                                    <i class="fas fa-times-circle"></i> <?= esc($result['error'] ?? 'Failed') ?>
                                </span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php elseif (!empty($results)): ?>
        <div class="results-table">
            <h3 class="table-title">
                <i class="fas fa-info-circle"></i> Summary
            </h3>
            <p style="color: #718096;">
                Generated credentials for <?= $created ?> businesses. 
                Due to the large number of records, individual details are not shown here. 
                Please download the CSV file for the complete list.
            </p>
        </div>
        <?php endif; ?>

        <div class="action-buttons">
            <a href="/admin/tools/manage-passwords" class="btn btn-primary">
                <i class="fas fa-key"></i> Manage Passwords
            </a>
            <a href="/admin/tools" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Tools
            </a>
        </div>
    </main>
</body>
</html>