<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #333;
        }

        .admin-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
            padding: 1rem 0;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
        }

        .nav-container {
            max-width: 1400px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 2rem;
        }

        .nav-brand {
            font-size: 1.5rem;
            font-weight: 700;
            color: #4a5568;
            text-decoration: none;
        }

        .nav-links {
            display: flex;
            gap: 0;
        }

        .nav-links a {
            color: #4a5568;
            text-decoration: none;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .nav-links a:hover {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }

        .nav-links a.active {
            background: #667eea;
            color: white;
            box-shadow: 0 2px 10px rgba(102, 126, 234, 0.3);
        }

        .logout-btn {
            background: #e53e3e;
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .logout-btn:hover {
            background: #c53030;
        }

        .main-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 2rem;
        }

        .breadcrumb {
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(10px);
            border-radius: 10px;
            padding: 1rem 1.5rem;
            margin-bottom: 2rem;
            font-size: 0.9rem;
        }

        .breadcrumb a {
            color: #667eea;
            text-decoration: none;
        }

        .breadcrumb a:hover {
            text-decoration: underline;
        }

        .page-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
        }

        .page-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }

        .page-subtitle {
            color: #718096;
            font-size: 1.1rem;
        }

        .form-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
        }

        .form-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 2rem;
        }

        .form-section {
            background: #f8fafc;
            border-radius: 12px;
            padding: 1.5rem;
            border: 2px solid #e2e8f0;
        }

        .section-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 600;
            color: #4a5568;
            font-size: 0.9rem;
        }

        .form-input, .form-select, .form-textarea {
            width: 100%;
            padding: 0.875rem 1rem;
            border: 2px solid #e2e8f0;
            border-radius: 10px;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: white;
        }

        .form-input:focus, .form-select:focus, .form-textarea:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .form-textarea {
            resize: vertical;
            min-height: 100px;
        }

        .checkbox-group {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 1rem;
            background: white;
            border-radius: 10px;
            border: 2px solid #e2e8f0;
            transition: all 0.3s ease;
        }

        .checkbox-group:has(input:checked) {
            border-color: #667eea;
            background: rgba(102, 126, 234, 0.05);
        }

        .checkbox-group input[type="checkbox"] {
            width: 18px;
            height: 18px;
            cursor: pointer;
        }

        .checkbox-group label {
            font-weight: 500;
            cursor: pointer;
            margin: 0;
        }

        /* Category Selection Styles */
        .categories-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 0.75rem;
            max-height: 300px;
            overflow-y: auto;
            padding: 1rem;
            background: white;
            border-radius: 10px;
            border: 2px solid #e2e8f0;
        }

        .category-option {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.75rem;
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            transition: all 0.3s ease;
            cursor: pointer;
            background: white;
        }

        .category-option:hover {
            border-color: #667eea;
            background: rgba(102, 126, 234, 0.05);
        }

        .category-option.selected {
            border-color: #667eea;
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
            font-weight: 600;
        }

        .category-icon {
            width: 30px;
            height: 30px;
            background: #f7fafc;
            border-radius: 6px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1rem;
        }

        .category-name {
            flex: 1;
            font-size: 0.9rem;
        }

        .category-checkbox {
            width: 16px;
            height: 16px;
        }

        .btn {
            padding: 0.875rem 1.5rem;
            border: none;
            border-radius: 10px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            cursor: pointer;
            font-size: 0.95rem;
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        }

        .btn-secondary {
            background: #f7fafc;
            color: #4a5568;
            border: 2px solid #e2e8f0;
        }

        .btn-secondary:hover {
            background: #edf2f7;
            border-color: #cbd5e0;
        }

        .btn-warning {
            background: #ed8936;
            color: white;
        }

        .form-actions {
            margin-top: 2rem;
            padding: 1.5rem;
            background: #f8fafc;
            border-radius: 12px;
            display: flex;
            gap: 1rem;
            justify-content: flex-end;
        }

        .alert {
            padding: 1rem 1.5rem;
            border-radius: 10px;
            margin-bottom: 1.5rem;
            border-left: 4px solid;
        }

        .alert-success {
            background: #f0fff4;
            border-color: #38a169;
            color: #22543d;
        }

        .alert-error {
            background: #fffaf0;
            border-color: #e53e3e;
            color: #742a2a;
        }

        .help-text {
            font-size: 0.8rem;
            color: #718096;
            margin-top: 0.25rem;
        }

        .video-preview {
            margin-top: 1rem;
            padding: 1rem;
            background: #e6fffa;
            border-radius: 8px;
            border: 1px solid #b2f5ea;
        }

        .full-width {
            grid-column: 1 / -1;
        }

        .category-stats {
            background: #ebf8ff;
            border: 1px solid #bee3f8;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
            font-size: 0.9rem;
            color: #2b6cb0;
        }

        @media (max-width: 768px) {
            .main-container {
                padding: 1rem;
            }
            
            .form-grid {
                grid-template-columns: 1fr;
            }
            
            .form-actions {
                flex-direction: column;
            }
            
            .categories-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <header class="admin-header">
        <div class="nav-container">
            <a href="/admin/dashboard" class="nav-brand">
                <i class="fas fa-store"></i> Business Directory Admin
            </a>
            
            <nav class="nav-links">
                <a href="/admin/dashboard">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
                <a href="/admin/stores" class="active">
                    <i class="fas fa-building"></i> Stores
                </a>
                <a href="/admin/hours">
                    <i class="fas fa-clock"></i> Hours
                </a>
                <a href="/admin/categories">
                    <i class="fas fa-tags"></i> Categories
                </a>
                <a href="/admin/settings">
                    <i class="fas fa-cog"></i> Settings
                </a>
            </nav>
            
            <div style="display: flex; align-items: center; gap: 1rem;">
                <span style="color: #666; font-size: 0.9rem;">
                    <i class="fas fa-user-circle"></i>
                    <?= session()->get('admin_name') ?>
                </span>
                <a href="/admin/logout" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
        </div>
    </header>

    <main class="main-container">
        <div class="breadcrumb">
            <i class="fas fa-home"></i>
            <a href="/admin/dashboard">Dashboard</a> /
            <a href="/admin/stores">Stores</a> /
            <a href="/admin/stores/view/<?= $store['id'] ?>"><?= esc($store['name']) ?></a> /
            Edit
        </div>

        <div class="page-header">
            <h1 class="page-title">
                <i class="fas fa-edit"></i> Edit Store
            </h1>
            <p class="page-subtitle">
                Update information for <?= esc($store['name']) ?>
            </p>
        </div>

        <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <?= session()->getFlashdata('success') ?>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-triangle"></i>
                <?= session()->getFlashdata('error') ?>
            </div>
        <?php endif; ?>

        <form method="post" class="form-container">
            <?= csrf_field() ?>
            
            <div class="form-grid">
                <!-- Basic Information -->
                <div class="form-section">
                    <h3 class="section-title">
                        <i class="fas fa-info-circle"></i>
                        Basic Information
                    </h3>
                    
                    <div class="form-group">
                        <label class="form-label" for="name">Business Name *</label>
                        <input type="text" id="name" name="name" class="form-input" 
                               value="<?= esc($store['name']) ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="description">Description</label>
                        <textarea id="description" name="description" class="form-textarea" 
                                  placeholder="Brief description of the business..."><?= esc($store['description']) ?></textarea>
                        <div class="help-text">Provide a brief description of the business and its services</div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="status">Business Status</label>
                        <select id="status" name="status" class="form-select">
                            <option value="1" <?= $store['status'] == 1 ? 'selected' : '' ?>>Active</option>
                            <option value="0" <?= $store['status'] == 0 ? 'selected' : '' ?>>Inactive</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <div class="checkbox-group">
                            <input type="checkbox" id="is_closed" name="is_closed" value="1" 
                                   <?= $store['is_closed'] == 1 ? 'checked' : '' ?>>
                            <label for="is_closed">Temporarily Closed</label>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="close_message">Closure Message</label>
                        <input type="text" id="close_message" name="close_message" class="form-input" 
                               value="<?= esc($store['close_message']) ?>" 
                               placeholder="Reason for temporary closure...">
                        <div class="help-text">Message to display when business is temporarily closed</div>
                    </div>
                </div>

                <!-- Contact Information -->
                <div class="form-section">
                    <h3 class="section-title">
                        <i class="fas fa-address-card"></i>
                        Contact Information
                    </h3>
                    
                    <div class="form-group">
                        <label class="form-label" for="phone">Phone Number</label>
                        <input type="tel" id="phone" name="phone" class="form-input" 
                               value="<?= esc($store['phone']) ?>" 
                               placeholder="+1 (423) 123-4567">
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="email">Email Address</label>
                        <input type="email" id="email" name="email" class="form-input" 
                               value="<?= esc($store['email']) ?>" 
                               placeholder="business@example.com">
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="website">Website URL</label>
                        <input type="url" id="website" name="website" class="form-input" 
                               value="<?= esc($store['website']) ?>" 
                               placeholder="https://www.business.com">
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="fax">Fax Number</label>
                        <input type="tel" id="fax" name="fax" class="form-input" 
                               value="<?= esc($store['fax']) ?>" 
                               placeholder="+1 (423) 123-4568">
                    </div>
                </div>

                <!-- Location Information -->
                <div class="form-section">
                    <h3 class="section-title">
                        <i class="fas fa-map-marker-alt"></i>
                        Location
                    </h3>
                    
                    <div class="form-group">
                        <label class="form-label" for="address">Street Address *</label>
                        <input type="text" id="address" name="address" class="form-input" 
                               value="<?= esc($store['address']) ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="city">City *</label>
                        <input type="text" id="city" name="city" class="form-input" 
                               value="<?= esc($store['city']) ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="state">State *</label>
                        <input type="text" id="state" name="state" class="form-input" 
                               value="<?= esc($store['state']) ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="postal_code">Postal Code</label>
                        <input type="text" id="postal_code" name="postal_code" class="form-input" 
                               value="<?= esc($store['postal_code']) ?>">
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="store_timezone">Timezone</label>
                        <select id="store_timezone" name="store_timezone" class="form-select">
                            <option value="America/New_York" <?= $store['store_timezone'] == 'America/New_York' ? 'selected' : '' ?>>Eastern Time</option>
                            <option value="America/Chicago" <?= $store['store_timezone'] == 'America/Chicago' ? 'selected' : '' ?>>Central Time</option>
                            <option value="America/Denver" <?= $store['store_timezone'] == 'America/Denver' ? 'selected' : '' ?>>Mountain Time</option>
                            <option value="America/Los_Angeles" <?= $store['store_timezone'] == 'America/Los_Angeles' ? 'selected' : '' ?>>Pacific Time</option>
                        </select>
                    </div>
                </div>

                <!-- Social Media & Video -->
                <div class="form-section">
                    <h3 class="section-title">
                        <i class="fas fa-share-alt"></i>
                        Social Media & Video
                    </h3>
                    
                    <div class="form-group">
                        <label class="form-label" for="facebook">Facebook URL</label>
                        <input type="url" id="facebook" name="facebook" class="form-input" 
                               value="<?= esc($store['facebook']) ?>" 
                               placeholder="https://facebook.com/business">
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="instagram">Instagram URL</label>
                        <input type="url" id="instagram" name="instagram" class="form-input" 
                               value="<?= esc($store['instagram']) ?>" 
                               placeholder="https://instagram.com/business">
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="twitter">Twitter URL</label>
                        <input type="url" id="twitter" name="twitter" class="form-input" 
                               value="<?= esc($store['twitter']) ?>" 
                               placeholder="https://twitter.com/business">
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="vimeo_id">Vimeo Video ID</label>
                        <input type="text" id="vimeo_id" name="vimeo_id" class="form-input" 
                               value="<?= !empty($store['additional_info']) ? esc($store['additional_info']) : '' ?>" 
                               placeholder="904259870">
                        <div class="help-text">Enter just the Vimeo video ID number (e.g., 904259870)</div>
                        
                        <?php if (!empty($store['additional_info'])): ?>
                            <div class="video-preview">
                                <i class="fas fa-video"></i>
                                <strong>Current Video:</strong> ID <?= esc($store['additional_info']) ?>
                                <br>
                                <small>The video will be embedded with responsive styling</small>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Category Assignment Section -->
                <div class="form-section full-width">
                    <h3 class="section-title">
                        <i class="fas fa-tags"></i>
                        Category Assignment
                    </h3>
                    
                    <div class="category-stats">
                        <i class="fas fa-info-circle"></i>
                        <strong>Categories help customers find this business.</strong>
                        Select all relevant categories that describe the business's services.
                        Currently <?= count($assignedCategoryIds) ?> categories assigned.
                    </div>

                    <div class="form-group">
                        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem;">
                            <label class="form-label">Select Categories</label>
                            <div>
                                <button type="button" class="btn btn-secondary btn-sm" onclick="selectAllCategories()">
                                    <i class="fas fa-check-double"></i> Select All
                                </button>
                                <button type="button" class="btn btn-warning btn-sm" onclick="clearAllCategories()">
                                    <i class="fas fa-times"></i> Clear All
                                </button>
                            </div>
                        </div>
                        
                        <div class="categories-grid">
                            <?php foreach ($allCategories as $category): ?>
                                <div class="category-option <?= in_array($category['category_id'], $assignedCategoryIds) ? 'selected' : '' ?>" 
                                     onclick="toggleCategory('<?= $category['category_id'] ?>')">
                                    <div class="category-icon">
                                        <i class="<?= esc($category['icon']) ?>"></i>
                                    </div>
                                    <div class="category-name">
                                        <?= esc($category['title']) ?>
                                    </div>
                                    <input type="checkbox" 
                                           class="category-checkbox" 
                                           name="categories[]" 
                                           value="<?= esc($category['category_id']) ?>" 
                                           id="category-<?= $category['category_id'] ?>"
                                           <?= in_array($category['category_id'], $assignedCategoryIds) ? 'checked' : '' ?>>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        
                        <?php if (empty($allCategories)): ?>
                            <div style="text-align: center; padding: 2rem; color: #a0aec0;">
                                <i class="fas fa-tags" style="font-size: 2rem; margin-bottom: 1rem;"></i>
                                <p>No categories available. <a href="/admin/categories/create" style="color: #667eea;">Create categories first</a>.</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="form-actions">
                <a href="/admin/stores/view/<?= $store['id'] ?>" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Cancel
                </a>
                
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Save Changes
                </button>
            </div>
        </form>
    </main>

    <script>
        // Category selection functionality
        function toggleCategory(categoryId) {
            const checkbox = document.getElementById(`category-${categoryId}`);
            const option = checkbox.closest('.category-option');
            
            checkbox.checked = !checkbox.checked;
            
            if (checkbox.checked) {
                option.classList.add('selected');
            } else {
                option.classList.remove('selected');
            }
        }
        
        function selectAllCategories() {
            document.querySelectorAll('.category-checkbox').forEach(checkbox => {
                checkbox.checked = true;
                checkbox.closest('.category-option').classList.add('selected');
            });
        }
        
        function clearAllCategories() {
            document.querySelectorAll('.category-checkbox').forEach(checkbox => {
                checkbox.checked = false;
                checkbox.closest('.category-option').classList.remove('selected');
            });
        }

        // Toggle closure message field based on temporarily closed checkbox
        document.getElementById('is_closed').addEventListener('change', function() {
            const closeMessageGroup = document.getElementById('close_message').closest('.form-group');
            if (this.checked) {
                closeMessageGroup.style.opacity = '1';
                document.getElementById('close_message').focus();
            } else {
                closeMessageGroup.style.opacity = '0.6';
                document.getElementById('close_message').value = '';
            }
        });

        // Initialize closure message visibility
        document.addEventListener('DOMContentLoaded', function() {
            const isClosedCheckbox = document.getElementById('is_closed');
            const closeMessageGroup = document.getElementById('close_message').closest('.form-group');
            
            if (!isClosedCheckbox.checked) {
                closeMessageGroup.style.opacity = '0.6';
            }
        });
    </script>
</body>
</html>