<?php

namespace App\Controllers\Frontend\Ajax;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;
use Config\Database;

class Locator extends BaseController
{
    /**
     * Handles AJAX requests to locate nearby businesses.
     * Expects POST data: lat, lng, optional keyword. Returns HTML cards.
     */
    public function index(): ResponseInterface
    {
        $request = service('request');
        $lat = $request->getPost('lat');
        $lng = $request->getPost('lng');
        $keyword = $request->getPost('keyword');
        $page = (int) $request->getGet('page') ?: 1;
        $perPage = 10;
        $offset = ($page - 1) * $perPage;

        if (!$lat || !$lng) {
            // Fallback to Athens, TN coordinates
            $lat = 35.4420;
            $lng = -84.5927;
        }

        $db = Database::connect();

        // Use Haversine formula to calculate distance in miles
        $builder = $db->table('store');
        $builder->select("*, 
            (3959 * acos(cos(radians($lat)) * cos(radians(CAST(latitude AS DECIMAL(10,6)))) * 
            cos(radians(CAST(longitude AS DECIMAL(10,6))) - radians($lng)) + 
            sin(radians($lat)) * sin(radians(CAST(latitude AS DECIMAL(10,6)))))) AS distance"
        );

        if (!empty($keyword)) {
            $builder->groupStart();
            $builder->like('name', $keyword);
            $builder->orLike('description', $keyword);
            $builder->groupEnd();
        }

        $builder->orderBy('distance', 'ASC');
        $builder->limit($perPage, $offset);

        $stores = $builder->get()->getResultArray();

        // This line must be active for the AJAX loader to render cards
        return service('response')->setBody(view('partials/store_card', ['stores' => $stores]));
    }
}
