<?php
use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

// ==========================================
// CUSTOMER FEEDBACK ROUTES (MOVED TO TOP)
// ==========================================
$routes->get('feedback/(:any)', 'Feedback::qr/$1');
$routes->post('feedback/(:any)', 'Feedback::qr/$1');
$routes->post('feedback/accept-google-review', 'Feedback::acceptGoogleReview');

// ==========================================
// PUBLIC ROUTES
// ==========================================
$routes->get('/', 'HomeController::index');
$routes->get('file-usage/report', 'HomeController::fileUsage');
$routes->get('hello', 'Hello::index');
$routes->get('test-db', 'TestDbController::index');

// Fix for the /public redirect issue
$routes->get('public', function() {
    return redirect()->to('/');
});

// ==========================================
// DEBUG ROUTES (remove in production)
// ==========================================
$routes->get('debug/time', 'TimeDebugController::index');

// ==========================================
// AJAX ROUTES
// ==========================================
$routes->post('ajax/locator', 'Frontend\Ajax\Locator::index');
// Support multiple formats for compatibility
$routes->post('ajax/store-details', 'Frontend\Ajax\StoreDetails::index');
$routes->post('ajax/store_details', 'Frontend\Ajax\StoreDetails::index');  
$routes->post('ajax/storedetails', 'Frontend\Ajax\StoreDetails::index');

// ==========================================
// PUBLIC API ROUTES
// ==========================================
$routes->get('api/categories', 'Admin\Categories::apiCategories');

// ==========================================
// VERIFICATION TOOL ROUTES
// ==========================================
$routes->get('verification', 'VerificationTool::index');
$routes->post('verification/check-password', 'VerificationTool::checkPassword');
$routes->post('verification/data', 'VerificationTool::getData');
$routes->post('verification/verify', 'VerificationTool::verify');
$routes->post('verification/save-notes', 'VerificationTool::saveNotes');
$routes->post('verification/add-business', 'VerificationTool::addBusiness');
$routes->post('verification/mark-inactive', 'VerificationTool::markInactive');
$routes->get('verification/stats', 'VerificationTool::getStats');

// ==========================================
// BUSINESS PORTAL ROUTES
// ==========================================

// Business Authentication
$routes->get('business/auth/login', 'Business\Auth::login');
$routes->post('business/auth/login', 'Business\Auth::attemptLogin');
$routes->get('business/auth/logout', 'Business\Auth::logout');
$routes->get('business/auth/first-login', 'Business\Auth::firstLogin');
$routes->post('business/auth/first-login', 'Business\Auth::saveContactInfo');
$routes->get('business/auth/change-password', 'Business\Auth::changePassword');
$routes->post('business/auth/change-password', 'Business\Auth::updatePassword');
$routes->get('business/auth/forgot-password', 'Business\Auth::forgotPassword');
$routes->post('business/auth/forgot-password', 'Business\Auth::processForgotPassword');

// Business Dashboard
$routes->get('business/dashboard', 'Business\Dashboard::index');
$routes->get('business/dashboard/profile', 'Business\Dashboard::profile');
$routes->get('business/dashboard/change-requests', 'Business\Dashboard::changeRequests');
$routes->get('business/dashboard/change-requests/view/(:num)', 'Business\Dashboard::viewChangeRequest/$1');
$routes->get('business/dashboard/settings', 'Business\Dashboard::settings');
$routes->post('business/dashboard/settings', 'Business\Dashboard::updateAccount');

// Business Feedback Management - Clean RESTful routes
$routes->group('business/feedback', ['namespace' => 'App\Controllers\Business'], function($routes) {
    // Main feedback dashboard
    $routes->get('/', 'Feedback::index');
    
    // Settings management
    $routes->get('settings', 'Feedback::settings');
    $routes->post('settings', 'Feedback::updateSettings');
    
    // QR Code generation and download
    $routes->get('qr-image/(:any)', 'Feedback::qrImage/$1');
    $routes->get('qr-download/(:any)', 'Feedback::qrDownload/$1');
    
    // Case management
    $routes->get('cases', 'Feedback::cases');
    $routes->get('case/(:segment)', 'Feedback::viewCase/$1');
    $routes->post('case/(:segment)/message', 'Feedback::sendMessage/$1');
    $routes->post('case/(:segment)/close', 'Feedback::closeCase/$1');
    $routes->post('case/(:segment)/priority', 'Feedback::updatePriority/$1');
    
    // Messaging interface
    $routes->get('case/(:segment)/messages', 'Feedback::messages/$1');
    
    // AJAX endpoints
    $routes->get('case/(:segment)/details', 'Feedback::caseDetails/$1');
    $routes->get('case/(:segment)/poll', 'Feedback::pollMessages/$1');
    $routes->post('case/(:segment)/mark-read', 'Feedback::markMessagesRead/$1');
});

// Business Onboarding (Fast, Guided Setup)
$routes->get('business/onboarding', 'Business\Onboarding::index');
$routes->get('business/onboarding/step1', 'Business\Onboarding::step1');
$routes->post('business/onboarding/step1', 'Business\Onboarding::step1');
$routes->get('business/onboarding/step2', 'Business\Onboarding::step2');
$routes->post('business/onboarding/step2', 'Business\Onboarding::step2');
$routes->get('business/onboarding/step3', 'Business\Onboarding::step3');
$routes->post('business/onboarding/step3', 'Business\Onboarding::step3');
$routes->get('business/onboarding/step4', 'Business\Onboarding::step4');
$routes->post('business/onboarding/step4', 'Business\Onboarding::step4');

// Business Profile Management
$routes->get('business/profile/edit', 'Business\Profile::edit');
$routes->post('business/profile/edit', 'Business\Profile::update');
$routes->post('business/profile/preview', 'Business\Profile::preview');
$routes->get('business/profile/hours', 'Business\Profile::hours');
$routes->post('business/profile/hours', 'Business\Profile::updateHours');

// Business Coupon Management
$routes->get('business/coupons', 'Business\Coupons::index');
$routes->get('business/coupons/create', 'Business\Coupons::create');
$routes->post('business/coupons/create', 'Business\Coupons::create');
$routes->get('business/coupons/edit/(:num)', 'Business\Coupons::edit/$1');
$routes->post('business/coupons/edit/(:num)', 'Business\Coupons::edit/$1');
$routes->post('business/coupons/toggle/(:num)', 'Business\Coupons::toggle/$1');
$routes->delete('business/coupons/delete/(:num)', 'Business\Coupons::delete/$1');
$routes->get('business/coupons/details/(:num)', 'Business\Coupons::details/$1');
$routes->get('business/coupons/preview/(:num)', 'Business\Coupons::preview/$1');

// Business Job Management
$routes->get('business/jobs', 'Business\Jobs::index');
$routes->get('business/jobs/create', 'Business\Jobs::create');
$routes->post('business/jobs/create', 'Business\Jobs::create');
$routes->get('business/jobs/edit/(:num)', 'Business\Jobs::edit/$1');
$routes->post('business/jobs/edit/(:num)', 'Business\Jobs::edit/$1');
$routes->post('business/jobs/toggle/(:num)', 'Business\Jobs::toggle/$1');
$routes->post('business/jobs/renew/(:num)', 'Business\Jobs::renew/$1');
$routes->delete('business/jobs/delete/(:num)', 'Business\Jobs::delete/$1');
$routes->get('business/jobs/details/(:num)', 'Business\Jobs::details/$1');
$routes->get('business/jobs/preview/(:num)', 'Business\Jobs::preview/$1');

// ==========================================
// ADMIN ROUTES
// ==========================================

// Admin Authentication
$routes->get('admin/login', 'Admin\Auth::login');
$routes->post('admin/login', 'Admin\Auth::login');
$routes->get('admin/logout', 'Admin\Auth::logout');

// Admin Dashboard
$routes->get('admin/dashboard', 'Admin\Dashboard::index');

// Admin Change Requests Management
$routes->get('admin/change-requests', 'Admin\ChangeRequests::index');
$routes->get('admin/change-requests/review/(:num)', 'Admin\ChangeRequests::review/$1');
$routes->post('admin/change-requests/approve/(:num)', 'Admin\ChangeRequests::approve/$1');
$routes->post('admin/change-requests/reject/(:num)', 'Admin\ChangeRequests::reject/$1');
$routes->post('admin/change-requests/bulk-approve', 'Admin\ChangeRequests::bulkApprove');
$routes->get('admin/change-requests/pending-count', 'Admin\ChangeRequests::getPendingCount');
$routes->get('admin/change-requests/test-email', 'Admin\ChangeRequests::testEmail');

// Admin Tools
$routes->get('admin/tools', 'Admin\Tools::index');
$routes->get('admin/tools/generate-users', 'Admin\Tools::generateBusinessUsers');
$routes->post('admin/tools/generate-users', 'Admin\Tools::processGenerateUsers');
$routes->get('admin/tools/download-credentials', 'Admin\Tools::downloadCredentials');
$routes->get('admin/tools/manage-passwords', 'Admin\Tools::managePasswords');
$routes->get('admin/tools/reset-password/(:num)', 'Admin\Tools::resetPassword/$1');

// Admin Store Management
$routes->get('admin/stores', 'Admin\Stores::index');
$routes->get('admin/stores/view/(:num)', 'Admin\Stores::view/$1');
$routes->get('admin/stores/edit/(:num)', 'Admin\Stores::edit/$1');
$routes->post('admin/stores/edit/(:num)', 'Admin\Stores::edit/$1');
$routes->post('admin/stores/bulk-assign-categories', 'Admin\Stores::bulkAssignCategories');
$routes->post('admin/stores/delete-business', 'Admin\Stores::deleteBusiness');

// Admin Category Management
$routes->get('admin/categories', 'Admin\Categories::index');
$routes->get('admin/categories/create', 'Admin\Categories::create');
$routes->post('admin/categories/create', 'Admin\Categories::store');
$routes->get('admin/categories/edit/(:num)', 'Admin\Categories::edit/$1');
$routes->post('admin/categories/edit/(:num)', 'Admin\Categories::update/$1');
$routes->post('admin/categories/delete/(:num)', 'Admin\Categories::delete/$1');
$routes->post('admin/categories/bulk-action', 'Admin\Categories::bulkAction');
$routes->get('admin/categories/assignments', 'Admin\Categories::assignments');
$routes->get('admin/categories/api', 'Admin\Categories::apiCategories');
$routes->get('admin/categories/api-top', 'Admin\Categories::apiTopCategories');
$routes->get('admin/categories/suggest-consolidation', 'Admin\Categories::suggestConsolidation');
$routes->get('admin/categories/stores/(:any)', 'Admin\Categories::storesByCategory/$1');

// Admin Hours Management
$routes->get('admin/hours', 'Admin\Hours::index');
$routes->get('admin/hours/store/(:any)', 'Admin\Hours::store/$1');
$routes->post('admin/hours/save-schedule', 'Admin\Hours::saveSchedule');
$routes->post('admin/hours/add-hour-type', 'Admin\Hours::addHourType');
$routes->post('admin/hours/add-exception', 'Admin\Hours::addException');
$routes->get('admin/hours/api-status/(:any)', 'Admin\Hours::apiStatus/$1');
$routes->post('admin/hours/bulk-update', 'Admin\Hours::bulkUpdate');

// Admin Hours Import Tool
$routes->get('admin/hours-import', 'Admin\HoursImport::index');
$routes->get('admin/hours-import/get-business-data', 'Admin\HoursImport::getBusinessData');
$routes->get('admin/hours-import/get-existing-services/(:any)', 'Admin\HoursImport::getExistingServices/$1');
$routes->post('admin/hours-import/search-hours', 'Admin\HoursImport::searchHours');
$routes->post('admin/hours-import/import-hours', 'Admin\HoursImport::importHours');
$routes->post('admin/hours-import/bulk-import', 'Admin\HoursImport::bulkImport');
$routes->get('admin/hours-import/get-business-hours', 'Admin\HoursImport::getBusinessHours');
$routes->post('admin/hours-import/delete-hour-type', 'Admin\HoursImport::deleteHourType');
$routes->post('admin/hours-import/bulk-clear-test-data', 'Admin\HoursImport::bulkClearTestData');
$routes->get('admin/test-google-simple', 'Admin\HoursImport::testGoogleApiSimple');
$routes->get('admin/test-place-details', 'Admin\HoursImport::testPlaceDetailsMinimal');

// Admin Job Management
$routes->get('admin/jobs', 'Admin\Jobs::index');
$routes->get('admin/jobs/view/(:num)', 'Admin\Jobs::view/$1');
$routes->post('admin/jobs/delete/(:num)', 'Admin\Jobs::delete/$1');
$routes->get('admin/jobs/export', 'Admin\Jobs::export');

// Admin Settings
$routes->get('admin/settings', 'Admin\Settings::index');
$routes->post('admin/settings', 'Admin\Settings::index');

// Temporary Debug Routes
$routes->get('test-auth', 'Admin\Auth::login');
$routes->get('admin/test-auth', 'Admin\TestAuth::index');

// ==========================================
// CRON JOB ROUTES (CLI access only)
// ==========================================
if (is_cli()) {
    $routes->cli('cron/store-status-updater/updateAllStatuses', 'Cron\StoreStatusUpdater::updateAllStatuses');
}
// Add these lines to serve the badge files directly
$routes->get('badge.js', function() {
    $file = FCPATH . 'badge.js';
    if (file_exists($file)) {
        header('Content-Type: application/javascript');
        readfile($file);
        exit;
    }
    throw new \CodeIgniter\Exceptions\PageNotFoundException();
});

$routes->post('badge-verify.php', function() {
    include FCPATH . 'badge-verify.php';
    exit;
});